USE [CRS]
GO
/****** Object:  StoredProcedure [CRS].[usp_STD_REGISTRY_delete]    Script Date: 11/10/2017 12:19:11 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO








-- =============================================
-- Author:        
-- Create date:   12/02/2015
-- Description:   Delete record by ID
-- =============================================
ALTER PROCEDURE [CRS].[usp_STD_REGISTRY_delete] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @CoreRegistryCode VARCHAR(50) = 'CRS';
	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUserRole](@CURRENT_USER, 0, 'CRSADMIN,REGADMIN') = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_STD_REGISTRY_delete', @ErrorMsg, 'User is not part of an Admin Role', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	DECLARE @Code VARCHAR(50)
	IF(SELECT Code FROM CRS.STD_REGISTRY WHERE ID = @ID) = @CoreRegistryCode
	BEGIN
		SET @ErrorMsg = 'This registry cannot be deleted.';
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	DECLARE @OldValues varchar(max);
	SELECT @OldValues = '<CODE>' + ISNULL(CAST([CODE] AS varchar), '') + '</CODE><COMMENTS>' + ISNULL(CAST([COMMENTS] AS varchar), '') + '</COMMENTS><CREATED>' + ISNULL(CAST([CREATED] AS varchar), '') + '</CREATED><CREATEDBY>' + ISNULL(CAST([CREATEDBY] AS varchar), '') + '</CREATEDBY><DESCRIPTION_TEXT>' + ISNULL(CAST([DESCRIPTION_TEXT] AS varchar), '') + '</DESCRIPTION_TEXT><ID>' + ISNULL(CAST([ID] AS varchar), '') + '</ID><INACTIVE_DATE>' + ISNULL(CAST([INACTIVE_DATE] AS varchar), '') + '</INACTIVE_DATE><INACTIVE_FLAG>' + ISNULL(CAST([INACTIVE_FLAG] AS varchar), '') + '</INACTIVE_FLAG><NAME>' + ISNULL(CAST([NAME] AS varchar), '') + '</NAME><REGISTRY_ADMINISTRATOR>' + ISNULL(CAST([REGISTRY_ADMINISTRATOR] AS varchar), '') + '</REGISTRY_ADMINISTRATOR><REGISTRY_OWNER>' + ISNULL(CAST([REGISTRY_OWNER] AS varchar), '') + '</REGISTRY_OWNER><REGISTRY_SUPPORT_CONTACT>' + ISNULL(CAST([REGISTRY_SUPPORT_CONTACT] AS varchar), '') + '</REGISTRY_SUPPORT_CONTACT><SORT_ORDER>' + ISNULL(CAST([SORT_ORDER] AS varchar), '') + '</SORT_ORDER><UPDATED>' + ISNULL(CAST([UPDATED] AS varchar), '') + '</UPDATED><UPDATEDBY>' + ISNULL(CAST([UPDATEDBY] AS varchar), '') + '</UPDATEDBY>' FROM [CRS].[STD_REGISTRY] WHERE [ID] = @ID;
	SELECT @ErrorMsg = '[CRS].[STD_REGISTRY] values deleted (Old Values:' + @OldValues + ' ) by (' + @CURRENT_USER + ')';
	EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_STD_REGISTRY_delete', @ErrorMsg, NULL, @CURRENT_USER;

	UPDATE [CRS].[STD_REGISTRY] SET [INACTIVE_FLAG] = 1 WHERE [ID] = @ID;
END









